#!/bin/sh

case $0 in
        /*) rootdir=$(cd "$(dirname $0)"; pwd); ;;
        *)  rootdir=$(cd "$(dirname $(pwd)/$0)"; pwd); ;;
esac

esxi_H="${1}"
esxi_U="${2}"
esxi_P="${3}"
sandbox_U="${4}"
sandbox_P="${5}"
sandbox_vmpath="${6}"
sandbox_default_ipaddr="${7}"
os_start_time="${8}"
sc_install_time="${9}"

setup_logfile="${rootdir}/setup.log"
setup_logcount=10;
setup_logsize=10;	#in meta bytes

setup_message ()
{
    log_date=$(date '+%Y/%m/%d %H:%M:%S');

    if [ $# -eq 0 ]; then
        awk "{ printf(\"%s - %s\\n\", strftime(\"%Y/%m/%d %H:%M:%S\"), \$0) >> \"${setup_logfile}\"; }"
    else
        echo "${log_date} - (${BASH_LINENO[0]}) $*" >> ${setup_logfile}
    fi
}

setup_gettext ()
{
    gettext "Setup" "$1"
}

setup_printf ()
{
    printf "$@";
}

setup_rotate_log ()
{
    logfile=$1;
    count=$2;

    ndx=$(( ${count} - 1 ))

    rm -f "${logfile}.${ndx}";

    while [ ${ndx} -ge 1 ]; do
        mv -f "${logfile}.$(( ${ndx} - 1 ))" "${logfile}.${ndx}";
        ndx=$(( ${ndx} - 1 ));
    done

    mv -f "${logfile}" "${logfile}.${ndx}";
    touch "${logfile}";
}

setup_check_logs ()
{
    logsize=$(ls -1 "${setup_logfile}" | awk '{printf("%d", $5 / 1024 / 1024);}');
    if [ ${logsize} -ge ${setup_logsize} ]; then
        setup_rotate_log "${setup_logfile}" ${setup_logcount};
    fi
}

setup_ping ()
{
    ipaddr=$1;
    echo "ping -c 1 ${ipaddr}"
    ping -c 1 ${ipaddr} 2>&1 >/dev/null
    return $?;
}

mount_folder_at_sb() {
    mountRetry=0
    mountRetryMax=5
    mountRetryInterval=10
    remoteFolder="${1}"
    localFolder="${rootdir}/sandcastlelog"
    local msg
    while [ 1 ]; do
        msg=`mount -t cifs -o username=${sandbox_U},password=${sandbox_P} "${remoteFolder}" "${localFolder}" 2>&1`
        
        # success
        [ "${?}" -eq 0 ] && return 0
        
        # exceeds max retry count
        if [ "${mountRetry}" -ge "${mountRetryMax}" ]; then
            setup_message "Mount fail and exceeds max retry count: (${mountRetryMax})"
            return 1
        fi

        # fail -> retry
        setup_message "Mount Fail...${msg}"
        setup_message "sleep ${mountRetryInterval} seconds..."
        sleep "${mountRetryInterval}"
        
        mountRetry=$(( ${mountRetry} + 1 ))
        
        setup_message "retry(${mountRetry}/${mountRetryMax})..."
    done
}

sandbox_install () {
    vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmpath}" start 2>&1 | setup_message;
    sleep ${os_start_time};
    
    count=5;
    ipaddr=${sandbox_default_ipaddr};
    ponged=1;

    while [ ${count} -gt 0 -a ${ponged} -eq 1 ]; do
        count=$(( ${count} - 1 ));
        
        # instert iso
        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmpath}" connectdevice "CD/DVD drive 1" 2>&1 | setup_message;
        setup_message "Insert CD!!";
        ping_count=10;
        while [ ${ping_count} -gt 0 ]; do
            ping_count=$(( ${ping_count} - 1 ));
            if setup_ping "${ipaddr}"; then
                setup_message "Pinging ${ipaddr}...ponged.";
                ponged=0;
                break;
            fi
            setup_message "Pinging ${ipaddr}..." ;
            sleep 30;
        done

        # remove sandcaslte dest log folder
        [ -e ${rootdir}/install_log ] && rm -rf ${rootdir}/install_log;
    
        # create sandcaslte src log folder
        [ ! -e ${rootdir}/sandcastlelog ] && mkdir ${rootdir}/sandcastlelog;

        # connnect shared folder for 5 times
        setup_message "mount -t cifs -o username=<hidden>,password=<hidden> //${ipaddr}/sandcastlelog ${rootdir}/sandcastlelog";
        install_sc=1;
        
        # mount sandbox share folder to get sandcastle's install log
        mount_folder_at_sb "//${ipaddr}/sandcastlelog"
        if [ "${?}" -eq 0 ]; then
            setup_message "Mount Success!!";
            sc_install_time_cnt=${sc_install_time};
            while [ $sc_install_time_cnt != 0 ]; do
                sc_install_time_cnt=$(( ${sc_install_time_cnt} - 1 ));
                sleep 1;
                [ -r "${rootdir}/sandcastlelog/Install.log" ] && tail -n 1 "${rootdir}/sandcastlelog/Install.log" | grep -q Install_SandCastle 2>&1 >/dev/null;
                if [ $? -eq 0 ]; then
                    setup_message "SandCastle Installation Completed";
                    break;
                fi
            done
            cp -ar ${rootdir}/sandcastlelog ${rootdir}/install_log;
            umount ${rootdir}/sandcastlelog;
            [ -r "${rootdir}/install_log/Install.log" ] &&\
                tail -n 1 ${rootdir}/install_log/Install.log | grep -q "Install_SandCastle, 0" &&\
                    [ -z "`cat ${rootdir}/install_log/Install.log | awk -F, 'BEGIN{result="";} $2 > " 0"  && $2 !=""{if(result!="") result = result ";"; result = result $1","$2","$3;} END {print result;}' | sed 's/\r//g'`" ];
            install_sc=$?;
            vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmpath}" disconnectdevice "CD/DVD drive 1" 2>&1 | setup_message;
            vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmpath}" connectdevice "CD/DVD drive 1" 2>&1 | setup_message;
            sleep 30;
            break;
        fi
        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmpath}" disconnectdevice "CD/DVD drive 1" 2>&1 | setup_message;
        setup_message "Eject CD!!";
    done
    
    return ${install_sc}
}

setup_check_logs;
sandbox_install;
ret="${?}"
setup_message "setup_sandbox exit with ${ret} !!";
exit "${ret}";
